function [M,sigma,systems,parameters]= calculateParamsForBinetCauchyKernels(systems,parameters)
% Compute the Binet-Cauchy kernels between dynamical systems
%
% INPUTS
%   systems     -   cell array of system parameters
%   parameters  -   parameters for computing the various Binet-Cauchy
%                   kernels
%       .Lambda -       Dampening factor for the Binet-Cauchy kernels
%                       [Default: 0.9]
%
% OUTPUTS
%   M           -   Array of the solution for sylvester equation for all
%                   pairs of systems
%   sigma       -   initial state covariance estimate
%   systems     -   return systems
%   parameters  -   return parameters
%
% EXAMPLE
%
%% Written by : Avinash Ravichandran, Rizwan Chaudhry
%% $DATE      : 09-Sep-2011 17:57:43 $
%% $REVISION  : 0.5.0 $

if nargin<2
    Lambda = 0.9;
else
    Lambda = parameters.Lambda;
end

n     = size(systems{1}.A,1);
N     = length(systems);
M     = zeros(n,n,N,N);
sigma = zeros(n,n,N,N);

for i = 1:N
    parfor j = 1:N	
        M(:,:,i,j)     = dlyap(Lambda.*systems{i}.A', systems{j}.A, systems{i}.C' * systems{j}.C);
        sigma(:,:,i,j) = systems{j}.x0 * systems{i}.x0';
    end
end

