function mat = generateSyntheticVideos(vSize,order)
% Generates synthetic data from a LDS with random paramters
%
% Random parameters are first generated and a time series is generated using 
% these parameters. 
%
% INPUTS
%   vSize   - [p F] the number of pixels and frames for the sequence  
%   order   - order of the system and noise [n nv]
%
% OUTPUTS
%   mat     - output matrix of size p x F containing the synthetic data
%
% EXAMPLE
% 
%
%% Written by : Avinash Ravichandran, Rizwan Chaudhry
%% $DATE      : 09-Sep-2011 17:57:43 $
%% $REVISION  : 0.5.0 $

% Checking if we have noise order 
if length(order)==1
    n    = order(1);
    nv   = 1;
else
    n    = order(1);
    nv   = order(2);
end


p = vSize(1);
F = vSize(2);
A = randn(n,n);
C = randn(p,n);
C0 = rand(p,1);
Z0 = rand(n,1);


for i=1:F
    if i~=1
        Z(:,i) = A*Z0 + B*randn(n,1);
    else
        Z(:,i) = A*Z(:,i-1) + B*randn(n,1);
    end
    I(:,i) = C*Z(:.i)+ C0;
end
