function [ret,retStructure] = checkInputsForDistances(sType,inputsC)
% Helper function for the distance calculations
%
% This function checks the inputs that are passed to the different distance
% functions and returns a structure for the distance functions to work on 
%
% INPUTS
%   sType           - distance type 0: Subspace angle based, 1: Binet Cauchy based
%   inputsC         - inputs that are paseed to the distance funtion
%
% OUTPUTS
%   ret             - 0 is the input paramters are not correct, otherwise the 
%                     number of input parameters are returned
%   retStructure   
%    .computeParam  - indicates if the paramters for the distance needs to calculated 
%    .computeCustom - indicated if the paramters are default or custom 
%
% EXAMPLE
% 
%
%% Written by : Avinash Ravichandran, Rizwan Chaudhry
%% $DATE      : 09-Sep-2011 17:57:43 $
%% $REVISION  : 0.5.0 $

inputs = inputsC{1};
m = length(inputs);

switch sType
    case 0 %%% Subspace Angles
        switch m
            case 1
                m1 = ~isstruct(inputs{1});
                m2 = 1;
                m3 = 1;
                if (m1==1)
                    retStructure.computeParam  = 0;
                    retStructure.computeCustom = 0;
                end
                m4 = 1;

            case 2
                m1 = isstruct(inputs{1});
                m2 = isstruct(inputs{2});
                m3 = 1;
                m4 = 1;

                if (and(m1,m2))
                    retStructure.computeParam  = 1;
                    retStructure.computeCustom = 0;
                end

            case 3
                m1 = isstruct(inputs{1});
                m2 = isstruct(inputs{2});
                m3 = isstruct(inputs{3});

                if (m1&&m2&&m3)
                    retStructure.computeParam  = 1;
                    retStructure.computeCustom = 1;
                end
                m4 = 1;
        end


    case 1 %%% Binet Cauchy kernels
        switch m
            case 2
                m1 = isstruct(inputs{1});
                m2 = isstruct(inputs{2});
                m3 = 1;
                m4 = 1;

                if (m1&&m2)
                    retStructure.computeParam  = 1;
                    retStructure.computeCustom = 0;
                end

            case 3
                m1 = isstruct(inputs{1});
                m2 = isstruct(inputs{2});
                m3 = isstruct(inputs{3});
                m4 = 1;

                if (m1&&m2&&m3)
                    retStructure.computeParam  = 1;
                    retStructure.computeCustom = 1;
                end

            case 4
                m1 = ~isstruct(inputs{1});
                m2 = ~isstruct(inputs{2});
                m3 = iscell(inputs{3});
                m4 = isstruct(inputs{4});

                if (m1&&m2&&m3&&m4)
                    retStructure.computeParam  = 0;
                    retStructure.computeCustom = 0;
                end

        end

end

if (~m1 || ~m2 || ~m3 || ~m4 )
    ret = 0;
else
    ret = m;
end

