function distance = kernelToDistance(K)
% This function converts the all-pair kernel matrix K into distances
%
% INPUTS
%   K           - Kernel matrix
%
% OUTPUTS
%   distance    - Corresponding distance matrix
%
% EXAMPLE
% 
%
%% Written by : Avinash Ravichandran, Rizwan Chaudhry
%% $DATE      : 09-Sep-2011 17:57:43 $
%% $REVISION  : 0.5.0 $

distance = zeros(size(K));
N        = size(distance,1);

for i = 1:N
    for j = 1:N
        %%% Assumes that the Kernel is Normalized
        distance(i,j) = sqrt(2 - 2*K(i,j)/sqrt(K(i,i)*K(j,j)));
    end
end
    

