% This example demonstrates how to use the various distance functions

addpath('../systems');
addpath('../distances');
addpath('../helper');
addpath('../plots');

dParams.class = 2;  
order = 40;

load ../data/candle_4_A.mat
sysParam{1} = suboptimalSystemID(grayMat,[order 1],dParams);

load ../data/candle_5_A.mat
sysParam{2} = suboptimalSystemID(grayMat,[order 1],dParams);

load ../data/water_a_near_1_A.mat
sysParam{3} = suboptimalSystemID(grayMat,[order 1],dParams);

load ../data/water_a_near_2_A.mat
sysParam{4} = suboptimalSystemID(grayMat,[order 1],dParams);

clear grayMat;

D = calculateMetricLDS(sysParam,[1 2 3 4 5 20]);

subplot(3,2,1); plotDistance(D(:,:,1)); title('Finsler Distance');
subplot(3,2,2); plotDistance(D(:,:,2)); title('Martin Distance');
subplot(3,2,3); plotDistance(D(:,:,3)); title('Gap Distance');
subplot(3,2,4); plotDistance(D(:,:,4)); title('Frobenius Distance');
subplot(3,2,5); plotDistance(D(:,:,5)); title('Martin Kernel to Distance');
subplot(3,2,6); plotDistance(D(:,:,6)); title('Martin Kernel');

% Distance between two systems only
d1 = calculateFinslerDistance(sysParam{1}, sysParam{2});
% Check if equal to D(1,2,1) up to numerical error
disp(norm(d1 - D(1,2,1)));

