% This m-file generates training and test data for face databases
% d: vector containing different numbers for training faces
% iter: number of iterations for randomly choosing training data
% Train{i}(:,j,k): d-vector containing the indices of the d(i) tarining
% data for subject j in iteration k
% Test{i}(:,j,k): d-vector containing the indices of the test
% data for subject j in iteration k
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
%--------------------------------------------------------------------------


% Generating training and test data for YaleB database
clc, clear all
load YaleBCrop.mat
n = size(I,4);
N = size(I,3);
iter = 10;
d = [9 18 25 32];
for i = 1:length(d)
    m = d(i);
    for k = 1:iter
        for j = 1:n
            Tr{i}(:,j,k) = randsample(N,m);
            Ts{i}(:,j,k) = setdiff(1:N,Tr{i}(:,j,k));
        end
    end
end
save TrainTestIndx_YaleB.mat Tr Ts


% Generating training and test data for AR database
clear all
load ARCrop.mat
n = size(I,4);
N = [1:7 14:20];
iter = 10;
d = [7 9 11 13];
for i = 1:length(d)
    m = d(i);
    for j = 1:n
        Tr{i}(:,j,1) = N(1:m);
        Ts{i}(:,j,1) = setdiff(N,Tr{i}(:,j,1));
    end
    for k = 2:iter
        for j = 1:n
            Tr{i}(:,j,k) = randsample(N,m);
            Ts{i}(:,j,k) = setdiff(N,Tr{i}(:,j,k));
        end
    end
end
save TrainTestIndx_AR.mat Tr Ts