% This m-file runs the block-sparse recovery with random corruptions using 
% three convex programs based on L2/L1, L1/L1, and Linf/L1 optimization on 
% the Extended Yale B database.
% perc: percentage of random corruption in a test image
% avgrecrate: average recognition rate for the three optimization programs
% for different percentages of corruptions
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
%--------------------------------------------------------------------------

clc, clear all

for m = 1:5

    load YaleBSubsets.mat
    D = size(Ytest,1);
    n = size(Ytest,3);

    Ind = 1:19; % subset1: 1-7, subset2: 8:19
    d = length(Ind);
    perc = 0.1 * (m-1);
    p = round(perc * D);
    Blk = Ytrain(:,Ind,:);

    Txt = strcat('Yale_Corrupt_','p',num2str(perc),'G',num2str(n),'D',num2str(D),'d',num2str(d));
    for i = 1:n
        sub = i;
        for j = 1:size(Ytest,2)
            Ind = randsample(D,p);
            y = Ytest(:,j,i);
            y(Ind) = round(255*rand(p,1));
            y = y ./ norm(y);
            q = 2;
            [Bsr1,Bsr2,Sr,err_Bsr1,err_Bsr2,err_Sr] = BlockSparseCorrupted(y,Blk,sub,q);
            facerec(i,j,1) = Bsr1;
            facerec(i,j,2) = Bsr2;
            facerec(i,j,3) = Sr;
            eval(['save ' Txt '.mat facerec n d D perc p'])
        end
    end

    for p = 1:3
        avgrecrate(p) = sum( sum( facerec(:,:,p) ) ) / (n*size(Ytest,2));
    end
    eval(['save ' Txt '.mat avgrecrate facerec n d D perc p'])


    clear facerec;
    clear avgrecrate;
end