% I: row X col X N X n matrix of face images
% r0: downsampling scale 
% B: matrix of downsampled face images
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
%--------------------------------------------------------------------------


function B = ImageDownSample(I,r)

N = size(I,3); % number of images for each subject
n = size(I,4); % number of subjects
B = [];
for i = 1:n
    for j = 1:N
        X(:,j) = vec( double( imresize(I(:,:,j,i),r) ) );
    end
    B(:,:,i) = X;
    X = [];
end