function generate_outliers_randomwalk(path, sequencename, trials)
%function generate_outliers_randomwalk(path, sequencename)
%Generates outlying trajectories for a specific sequence. The trajectories
%are generated by starting a random walk at a random point in the image and
%adding to it increments taken from a trajectory (picked at random in the
%sequence) between two consecutive frames (again picked at random)
% Inputs:
%   path            relative path from the current directory to
%                   the Hopkins 155 database
%   sequencename    name of the sequence
%   trials          (optional) number of times to repeat the process
% Outputs
%   The function writes the file outliersdata.mat which contains two
%   variables of size [3 x Frames x Points x trials]: 
%       xoutliers   outliers in normalized coordinates
%       youtliers   outliers in standard coordinates

if(exist('trials','var')==0)
    trials=100;
end

%move in the project directory
fullpath=fullfile(path,sequencename);
if(~exist(fullpath,'dir'))
    error(['Project directory ''' sequencename '''doesn''t exist'])
end

cdold=cd;
cd(fullpath)

%load ground - truth
eval(['load ' sequencename '_truth.mat']);

N=length(s);
F=frames;
xoutliers=ones(3,N,F,trials);
allinc=reshape(diff(x(1:2,:,:),1,3),2,[],1);
fprintf('Generating outliers...')
for(itrial=1:trials)
    for(iout=1:N)
        p=randperm(size(allinc,2));
        rantrajinc=[2*rand(2,1)-1 allinc(:,p(1:F-1))];
        xoutliers(1:2,iout,:,itrial)=cumsum(rantrajinc,2);
    end
    if(mod(itrial,10)==0)
        fprintf('%d...',itrial)
    end
    
    for(iframe=1:F)
        youtliers(:,:,iframe,itrial)=round(K*xoutliers(:,:,iframe,itrial));
    end
end
fprintf('end\n')

save outliers_data xoutliers youtliers

cd(cdold)