% Example for Canonical Forms

addpath('../systems');
addpath('../distances');
addpath('../helper');
addpath('../plots');

order = 5;

load ../data/candle_4_A.mat
dParams.class = 2;
sysParam = suboptimalSystemID(grayMat/255,[order 1],dParams);

disp('A matrix from ID:');
disp(sysParam.A);
figure;
zplane(eig(sysParam.A));
title('Eigenvalues of A after initial system ID');

figure(200);
subplot(1,3,1);imagesc(sysParam.A);
title('A after initial system ID');



% Convert into several canonical forms
% Reachability Canonical Form:
P = convertToCanonicalForm(sysParam,1);
sysParamOut = transformBasis(sysParam,P);

disp('Reachability Canonical Form:');
disp(sysParamOut.A);
figure;
zplane(eig(sysParamOut.A));
title('Eigenvalues of A from the Reachability Canonical Form');

figure(200);
subplot(1,3,2);imagesc(sysParamOut.A);
title('A in the Reachability Canonical Form');

% Jordan Canonical Form:
P = convertToCanonicalForm(sysParam,2);
sysParamOut = transformBasis(sysParam,P);

disp('Jordan Canonical Form:');
disp(sysParamOut.A);
figure;
zplane(eig(sysParamOut.A));
title('Eigenvalues of A from the Jordan Canonical Form');

figure(200);
subplot(1,3,3);imagesc(sysParamOut.A);
title('A in the Jordan Canonical Form');
