function metricStruct  = defaultDistanceParameters(metric)
% Creates the default parameters for a given metric
% 
% The default paramters a calculated for a given metric. This is useful
% when using the distance computation between linear dynamical systems as
% most of the times the paramters are the same.
% 
% INPUTS 
%   metric       - Metric for which the default paramters need to be
%                  calculated. For the metric and their meaning, refer the
%                  distance computation toolbox.
% 
% OUTPUTS 
%   metricStruct  - Structure containing the metric parameters
%   .isARMA      
%   .metricParams
%   .mean_included
% 
% EXAMPLE 
% m = defaultDistanceParameters(2);

%% Written by : Avinash Ravichandran, Rizwan Chaudhry
%% $DATE      : 09-Sep-2011 17:57:43 $
%% $REVISION  : 0.5.0 $

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% Setting Metric Values
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

BinetCauchyRelatedDistancesKernels  = [6:9,12:14,21:24];
subspaceAnglesBasedDistancesKernels = [1,2,3,4,5,20];
polynomialKernels = [11,25];

for i = 1:length(BinetCauchyRelatedDistancesKernels)
    ind = find(metric == BinetCauchyRelatedDistancesKernels(i));
    if isempty(ind) == 0
        metricParams(ind).lambda = 0.9;
        metricParams(ind).cov_U = 1;
        metricParams(ind).alpha = 0.5;
    end
end


% Set ARMA parameters:
for i = 1:length(subspaceAnglesBasedDistancesKernels)
    ind = find(metric == subspaceAnglesBasedDistancesKernels(i));
    if isempty(ind) == 0
        metricParams(ind).isARMA = 0;
    end
end

for i = 1:length(polynomialKernels)
    ind = find(metric == polynomialKernels(i));
    if isempty(ind) == 0
        metricParams(ind).d = 1;
    end
end

% By Default mean is not included
mean_included = 0;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% Returning Values
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
metricStruct.metric        = metric;
metricStruct.metricParams  = metricParams;
metricStruct.mean_included = mean_included;
