function [angles,sigma,systems,mParam] = preprocessSystems(sType,varargin)
% This is a helper function for the distance calculation functions. 
%
% This function allows the distance functions to be called with different
% types of argumennts. 
%
% INPUTS
%   sType    - Distance type 0: Subspace Angle Distance, 1: Binet Cauchy Distance
%   varargin - All the arguments from the calling function
%
% OUTPUTS
%   angles  - Subspace angles for subspace angle distances, 
%             Solution of Sylvester equation for binet cauchy kernels
%   sigma   - Sigma for binet cauchy kernels
%   systems - Original input systems
%   mParam  - Metric parameters. Returns the default paramters if no metric parameters are passed.
%             If metric paramters are passed, then it returns the input metric parameters. Note that
%             for the case of subspace angle distance, no metric parameters are returned. The angles 
%             are calculated based on the paramters and returned.
%
% EXAMPLE
% 
%
%% Written by : Avinash Ravichandran, Rizwan Chaudhry
%% $DATE      : 09-Sep-2011 17:57:43 $
%% $REVISION  : 0.5.0 $

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialization and Error Checks
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[m,retStruct] = checkInputsForDistances(sType,varargin);
if ~m
    error('Inputs do not match the required format');
end
varargin = varargin{1};         % I THINK THIS NEEDS TO BE COMMENTED OUT (RAC)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Getting type of Input paramters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

switch sType
    case 0
        switch m
            case 1
                %%% One parameter case: Angles
                angles = varargin{1};
            case 2
                %%% Two parameters case: 2 Systems
                angles = subspaceAnglesAR(varargin{1},varargin{2});

            case 3
                %%% Three parameters case: 2 Systems and metric params
                metric = varargin{3};
                if metric.isARMA
                    angles = subspaceAnglesARMA(varargin{1},varargin{2});
                else
                    angles = subspaceAnglesAR(varargin{1},varargin{2});
                end
                sigma   =[];
                systems =[];
                mParam  =[];
        end

    case 1
        switch m
            case 2
                if (retStruct.computParam)
                    %%% Paramters need to be calculated
                    systems{1} = varargin{1};
                    systems{2} = varargin{2};
                    [angles,sigma,systems,mParam] = calculateParamsForBinetCauchyKernels(systems);
                end

            case 3
                %%% Paramters need to be calculated with custom paramters
                systems{1} = varargin{1};
                systems{2} = varargin{2};
                [angles,sigma,systems,mParam] = calculateParamsForBinetCauchyKernels(systems,varargin{3});
                
            case 4
                %%% Paramters are already given
                angles = varargin{1};
                sigma  = varargin{2};
                systems = varargin{3};
                mParam = varargin{4};
        end
end

