% This example demonstrates how we can learn and synthesize color videos of dynamic
% textures. The example here corresponds to Fig 10c in Doretto et al IJCV 03

load ../data/ocean-color
F = size(colorMat,4);
c = size(colorMat,2);
r = size(colorMat,1);
p = c*r;

% For the color case, we concatenate all the channels
vectorMat = zeros(3*p,F);
synthesizedMat = zeros(r,c,3,F);

for i=1:size(colorMat,4);
    vectorMat(:,i) = [ reshape(colorMat(:,:,1,i),[],1); ...
        reshape(colorMat(:,:,2,i),[],1); ...
        reshape(colorMat(:,:,3,i),[],1)];
end

% We now identify them as usual 
dParams.class = 2; 
sysParam = suboptimalSystemID(vectorMat,[50 1],dParams);
synthMat = generateFromLDS(sysParam,[size(vectorMat,1) size(vectorMat,2)]);   


% Once the synthesis is performed we unfold them
% and generating the images from the vector data
for i=1:size(synthMat,2);
    temp(:,:,1) = reshape(synthMat(1:p,i),[r c]);
    temp(:,:,2) = reshape(synthMat((1:p)+p,i),[r c]);
    temp(:,:,3) = reshape(synthMat((1:p)+2*p,i),[r c]);
    synthesizedMat(:,:,:,i) = temp;
end

 
% Plotting the original sequence along with the synthesized video sequence
for i=1:size(synthMat,2);
    subplot(1,2,1);
    imagesc(colorMat(:,:,:,i));
    axis off;
    title('Original');

    subplot(1,2,2);
    imagesc(uint8(synthesizedMat(:,:,:,i)));
    axis off;
    title('Synthesized');
    drawnow;
end

