function [Q,f]= align_SOn1_jacobi(A1,A2,C1,C2,lam_a,lam_c,iter_max,theta_thresh)
% works in the case C'C = eye(n)

if lam_a > 0
    
    [n,A_col]=size(A1);
    E=lam_c*C1'*C2;
    baseline_cost = 2*n*lam_c;
    [Q1,f1]=jacobi_align_short(A1',A2',E',baseline_cost,lam_a,iter_max,theta_thresh);
    
    Q_det=eye(n);
    Q_det(1,1)=-1;
    A1_neg = Q_det'*A1*Q_det;
    C1_neg = C1*Q_det;
    E_neg=lam_c*C1_neg'*C2;
    [Q2,f2]=jacobi_align_short(A1_neg',A2',E_neg',baseline_cost,lam_a,iter_max,theta_thresh);
    
    if f2 > f1
        Q=Q1;
        f=f1;
    else
        Q=Q_det*Q2;
        f=f2;
    end
    
else
    
    M = C1'*C2;
    [U,S,V] = svd(M);
    Q = U*V';
    f = lam_c*norm(C1*Q-C2,'fro')^2;
    
end
