function [cost_final,Q_final,Theta_final]=align_f2(A1,A2,B1,B2,C1,C2,lam_a,lam_b,lam_c,iter_max,Theta,QArray)
%[Q,f]= align_f1(A1,A2,B1,B2,C1,C2,lam_a,lam_b,lam_c,iter_max,theta_thresh,Q_init)
T=iter_max;
[n,A_col] = size(A1);
[init_count,row_x,col_x]=size(QArray);
QArray_new=zeros(init_count,n,n);
TArray_new=zeros(init_count,n,n);
Q_new=zeros(n,n);
out_cost=zeros(T,init_count);

for j=1:init_count
    f = zeros(T+1,1);
    Q_new(:,:)=QArray(j,:,:);
    f(1) = norm(C1-C2,'fro')^2 + norm(B1-B2,'fro')^2+ norm(A1-A2,'fro')^2;
    B1_cur = B1*Theta;
    Theta_new = eye(n);
    
    for k = 1: iter_max
        Q_input(1,:,:)=Q_new;
        [Q_out,f_out]= align_f1(A1,A2,B1_cur,B2,C1,C2,lam_a,lam_b,lam_c,3,0.001,Q_input);
        Q_new=Q_out;
        
        A1_mod = Q_new'*A1*Q_new;
        B1_mod = Q_new'*B1_cur;
        C1_mod = C1*Q_new;
        
        C1_equiv=B1_mod;
        C2_equiv=B2;
        M = C1_equiv'*C2_equiv;
        [U,S,V] = svd(M);
        Theta_mod = U*V';
        Theta_new=Theta_new*Theta_mod;
        B1_mod = B1_mod*Theta_mod;
        B1_cur=B1*Theta_new;
        f(k+1) = norm(C1_mod-C2,'fro')^2 + norm(B1_mod-B2,'fro')^2+ norm(A1_mod-A2,'fro')^2;
    end
    
    % only keep cost function up to the point the program ceases
    out_cost(:,j)=(f(1:T));
    QArray_new(j,:,:)=Q_new;
    TArray_new(j,:,:)=Theta_new;
end

min_cost= min(out_cost);
[val,min_ind]=min(min_cost);
cost_final=min(out_cost(:,min_ind));
Q_final=zeros(n,n);
Q_final(:,:)=QArray_new(min_ind,:,:);
Theta_final=zeros(n,n);
Theta_final(:,:)=TArray_new(min_ind,:,:);
