% TEST CODE 

% create MEX files
if exist('jacobi_align_short.mexa64')==0
    mex jacobi_align_short.cpp
end
    
if exist('jacobi_align_long.mexa64')==0
    mex jacobi_align_long.cpp 
end

if exist('jacobi_align_f3.mexa64')==0
    mex jacobi_align_f3.cpp
end

% mex jacobi_align_short.cpp 
% mex jacobi_align_long.cpp 
% mex jacobi_align_f3.cpp

iter_max=50;
lam_a=1;
lam_b=1;
lam_c=1;
theta_thresh=0.001;

% number of optimizations we want to try out
ct_max=1;
p = 120;
n = 5;
flag = 0;

QArray=zeros(2,n,n);
QArray(1,:,:)=eye(n);
Q_neg=eye(n);
Q_neg(1,1)=-1;
QArray(2,:,:)=Q_neg(:,:);
Theta=eye(n);

for ct=1:ct_max
    CArray(:,:) = randn(p,n);
    [U,S,V] = svd(CArray(:,:),0);
    CArray(:,:) = U;
    
    AArray(:,:) = randn(n,n);
    AArray(:,:) = AArray(:,:)/norm(AArray(:,:))*rand;
    BArray(:,:) = randn(n,n);
    BArray(:,:) = BArray(:,:)/norm(BArray(:,:));
    [U2,S2,V2] = svd(AArray(:,:),0);
    Q = U2*V2;
    
    A1 = AArray(:,:);
    C1 = CArray(:,:);
    A2 = Q'*A1*Q;
    C2 = C1*Q;
    B1 = BArray(:,:);
    B2 = Q'*B1;
    actualQ = Q;
    actualQ_trans = Q';
    
    [Q1,f1]= align_f1(A1,A2,B1,B2,C1,C2,lam_a,lam_b,lam_c,iter_max,theta_thresh,QArray)
    [f2,Q2,Theta_2]=align_f2(A1,A2,B1,B2,C1,C2,lam_a,lam_b,lam_c,iter_max,Theta,QArray)
    [Q3,f3]= align_f3(A1,A2,B1,B2,C1,C2,lam_a,lam_b,lam_c,iter_max,theta_thresh,QArray)
   
end
