function [cost_final,Q_final]=var_input_jacobi(A1_arr,A2_arr,B1_arr,B2_arr,C1_arr,C2_arr,QArray,iter_max)

root_type='matlab';

[A1_r,A1_c,A1_size]=size(A1_arr);
[B1_r,B1_c,B1_size]=size(B1_arr);
[C1_r,C1_c,C1_size]=size(C1_arr);

n=A1_r;
T=iter_max;

[row_x,col_x,init_count]=size(QArray);
QArray_new=zeros(init_count,n,n);
Q_new=eye(n,n);
out_cost=zeros(T,init_count);

A1_orig=A1_arr;
B1_orig=B1_arr;
C1_orig=C1_arr;

for j=1:init_count
    f = zeros(T+1,1);
    Q_new(:,:)=QArray(:,:,j);
    
    % update A parts
    for ind_a = 1:A1_size        
        A1(:,:) = A1_orig(:,:,ind_a);
        A1 = Q_new'*A1*Q_new;
        A1_arr(:,:,ind_a)=A1;  
    end
    
    % update B parts
    for ind_b = 1:B1_size
        
        B1(:,:) = B1_orig(:,:,ind_b);
        B1 = Q_new'*B1;
        B1_arr(:,:,ind_b)=B1;
        
    end
    
    
    % update C parts
    for ind_c = 1:C1_size
        
        C1(:,:) = C1_orig(:,:,ind_c);
        C1 = C1*Q_new;
        C1_arr(:,:,ind_b)=C1;
        
    end
    
    
    % OPTIMIZATION FOR POSITIVE DETERMINANT
    f(1) = 0;
    
    for ind_a=1:A1_size
        A1(:,:)=A1_arr(:,:,ind_a);
        A2(:,:)=A2_arr(:,:,ind_a);
        f(1)= f(1)+norm(A1-A2,'fro');
    end
    
    for ind_b=1:B1_size
        B1(:,:)=B1_arr(:,:,ind_b);
        B2(:,:)=B2_arr(:,:,ind_b);
        f(1)= f(1)+norm(B1-B2,'fro');
    end
    
    for ind_c=1:C1_size
        C1(:,:)=C1_arr(:,:,ind_c);
        C2(:,:)=C2_arr(:,:,ind_c);
        f(1)= f(1)+norm(C1-C2,'fro');
    end
    %norm(C1-C2,'fro')^2 + norm(B1-B2,'fro')^2+ norm(A1-A2,'fro')^2;
    
    % the following matrices will be consistently rotated by Jacobi matrices
    
    for k = 1: T
        conv_flag=1;
        % perform Jacobi rotations
        for p=1:(n-1)
            for q=(p+1):n
                
                K=zeros(1,5);
                % A part
                for ind_a = 1:A1_size
                    K(1) = K(1) + A1_arr(p,p,ind_a)*A2_arr(p,p,ind_a) + A1_arr(q,p,ind_a)*A2_arr(q,p,ind_a) + A1_arr(p,q,ind_a)*A2_arr(p,q,ind_a) + A1_arr(q,q,ind_a)*A2_arr(q,q,ind_a);
                    K(2) = K(2) + A1_arr(p,p,ind_a)*A2_arr(q,q,ind_a) - A1_arr(p,q,ind_a)*A2_arr(q,p,ind_a) - A1_arr(q,p,ind_a)*A2_arr(p,q,ind_a) + A1_arr(q,q,ind_a)*A2_arr(p,p,ind_a);
                    K(3) = K(3) + A1_arr(p,p,ind_a)*(-A2_arr(q,p,ind_a)-A2_arr(p,q,ind_a))+A1_arr(q,p,ind_a)*(A2_arr(p,p,ind_a)-A2_arr(q,q,ind_a))+ A1_arr(p,q,ind_a)*(A2_arr(p,p,ind_a)-A2_arr(q,q,ind_a))+A1_arr(q,q,ind_a)*(A2_arr(q,p,ind_a)+A2_arr(p,q,ind_a));
                    
                    A1_edit(:,:)=A1_arr(:,:,ind_a);
                    A1_edit([p,q],[p,q])=0;
                    A2_edit(:,:)=A2_arr(:,:,ind_a);
                    A2_edit([p,q],[p,q])=0;
                    
                    K(4) = K(4) + dot(A1_edit(p,:),A2_edit(p,:))  + dot(A1_edit(q,:),A2_edit(q,:)) + dot(A1_edit(:,p),A2_edit(:,p)) + dot(A1_edit(:,q),A2_edit(:,q));
                    K(5) = K(5) + dot(A1_edit(:,q),A2_edit(:,p))  + dot(A1_edit(q,:),A2_edit(p,:)) - dot(A1_edit(:,p),A2_edit(:,q)) - dot(A1_edit(p,:),A2_edit(q,:));
                    
                end
                
                % B part
                for ind_b = 1:B1_size
                    
                    B1(:,:)=B1_arr(:,:,ind_b);
                    B2(:,:)=B2_arr(:,:,ind_b);
                    D = B1*B2';
                    K(4)= K(4) + D(p,p) + D(q,q);
                    K(5)= K(5) + D(q,p) - D(p,q);
                    
                end
                
                % C part
                
                for ind_c = 1:C1_size
                    
                    C1(:,:)=C1_arr(:,:,ind_c);
                    C2(:,:)=C2_arr(:,:,ind_c);
                    E = C1'*C2;
                    K(4)= K(4) + E(p,p) + E(q,q);
                    K(5)= K(5) + E(q,p) - E(p,q);
                    
                end
                
                p_coef_2 = [4*K(3)^2 + 4*(K(2) - K(1))^2     ,    4*K(3)*K(5) + 4*K(4)*(K(1) - K(2))    ,    K(4)^2 - 4*K(3)^2 + K(5)^2 - 4*(K(2) - K(1))^2   ,   -2*K(3)*K(5) - 4*K(4)*(K(1) - K(2))     ,     K(3)^2 - K(4)^2];
                
                switch root_type
                    case 'matlab'
                        cosine_roots=roots(p_coef_2);
                    case 'ferrari'
                        cosine_roots=ferrari_roots(p_coef_2);
                    case 'strobach'
                        cosine_roots=strobach_roots(p_coef_2);
                end
                
                % prev_sine_flag tells us whether all the angles in the
                % previous sweep were small
                
                real_roots=real(cosine_roots(find(0.0001>abs(imag(cosine_roots)))));
                if strcmp(root_type,'ferrari')
                    for num_root=1:length(real_roots)
                        % root polishing
                        real_roots(num_root)=newton_raphson(p_coef_2,real_roots(num_root));
                    end
                end
                
                s_values = 0;
                c_values = 1;
                cost_vector = K(1) + K(4);
                
                for num=1:length(real_roots)
                    % now evaluate cost function at all values of s to check for
                    % maxima vs minima
                    
                    c = real_roots(num);
                    s = (2*K(3)*c^2+ K(5)*c - K(3))/(c*(2*(K(1)-K(2))) + K(4));
                    
                    if (abs(c^2 + s^2 - 1)>0.0001) || (abs(c)>1.0)
                        c=1;
                        s=0;
                    else
                        s=sign(s)*sqrt(1-c^2);
                    end
                    
                    cost_vector(end+1) = K(1)*c^2 + K(2)*s^2 + K(3)*c*s + K(4)*c + K(5)*s;
                    s_values(end+1) = s;
                    c_values(end+1) = c;
                end
                
                [val,ind]=max(cost_vector);
                c = c_values(ind);
                s = s_values(ind);
                if s==0
                    continue;
                else
                    conv_flag=0;
                end
                
                Q = eye(n);
                Q([p,q],[p,q])=[c,-s;s,c];
                Q_new = Q_new*Q;
                % update the following matrices to reflect rotation
                
                % update A parts
                for ind_a = 1:A1_size
                    A1(:,:) = A1_orig(:,:,ind_a);
                    A1 = Q_new'*A1*Q_new;
                    A1_arr(:,:,ind_a)=A1;
                end
                
                % update B parts
                for ind_b = 1:B1_size
                    
                    B1(:,:) = B1_orig(:,:,ind_b);
                    B1 = Q_new'*B1;
                    B1_arr(:,:,ind_b)=B1;
                    
                end
                
                
                % update C parts
                for ind_c = 1:C1_size
                    
                    C1(:,:) = C1_orig(:,:,ind_c);
                    C1 = C1*Q_new;
                    C1_arr(:,:,ind_b)=C1;
                    
                end
                
                
            end
        end
        
        f(k+1) = 0;
        for ind_a=1:A1_size
            A1(:,:)=A1_arr(:,:,ind_a);
            A2(:,:)=A2_arr(:,:,ind_a);
            f(k+1)= f(k+1)+norm(A1-A2,'fro');
        end
        
        for ind_b=1:B1_size
            B1(:,:)=B1_arr(:,:,ind_b);
            B2(:,:)=B2_arr(:,:,ind_b);
            f(k+1)= f(k+1)+norm(B1-B2,'fro');
        end
        
        for ind_c=1:C1_size
            C1(:,:)=C1_arr(:,:,ind_c);
            C2(:,:)=C2_arr(:,:,ind_c);
            f(k+1)= f(k+1)+norm(C1-C2,'fro');
        end
        
        
        if (conv_flag==1)&&(k+2<(T))
            f(k+2:end)=f(k+1);
            break
        end
        
    end
    
    % only keep cost function up to the point the program ceases
    out_cost(:,j)=(f(1:T));
    QArray_new(j,:,:)=Q_new;
    
end

min_cost= min(out_cost);
[val,min_ind]=min(min_cost);
cost_final=out_cost(:,min_ind);
Q_final=zeros(n,n);
Q_final(:,:)=QArray_new(min_ind,:,:);



