function [Q,f]= align_f1(A1,A2,B1,B2,C1,C2,lam_a,lam_b,lam_c,iter_max,theta_thresh,Q_init)
% Q_init is a an array of matrices

[init_ct,n,n2]=size(Q_init);
Q_sav=zeros(init_ct,n,n);
f_sav=zeros(1,init_ct);
[n,Acol]=size(A1);
E=lam_b*B1*B2'+lam_c*C1'*C2;
baseline_cost = lam_c*(trace(C1*C1') + trace(C2*C2')) + lam_b*(trace(B1*B1') + trace(B2*B2'));

for i=1:init_ct
    Q_cur(:,:)=Q_init(i,:,:);
    E_cur=Q_cur'*(E);
    A1_cur=Q_cur'*A1*Q_cur;
    [Q_out,f_out]=jacobi_align_short(A1_cur',A2',E_cur',baseline_cost,lam_a,iter_max,theta_thresh);
    Q_sav(i,:,:)=Q_cur*Q_out;
    f_sav(i)=f_out;
end

[val,ind]=min(f_sav);
f=val;
Q(:,:)=Q_sav(ind,:,:);

