% Y: D x N matrix of N data points in D dimensions
% d: dimension of projection
% Yp: d x N matrix of projected data points
% Up: D x d matrix of eigenfaces
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
%--------------------------------------------------------------------------


function [Yp,Up,y_mean] = Eigenface(Y,d)

y_mean = mean(Y,2);
Y = Y - repmat(y_mean,1,size(Y,2));
[U,~,~] = svd(Y,0);
Up = U(:,1:d);
Yp = Up' * Y;