% Y: D x N matrix of N data points in D dimensional space
% y: D x 1 test data vector
% Tn: vector of n elements indicating the number of trainings for each of
% the n class
% sub: index of the groundtruth subject for the test data y
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
%--------------------------------------------------------------------------


function [NN,err_NN] = NearestNeighbors(Y,y,Tn,sub)

n = length(Tn);
ind = 0;
for i = 1:n
    X(:,:,i) = Y(:,ind+1:ind+Tn(i));
    ind = ind + Tn(i);
    for j = 1:Tn(i)
        Perr_NN(j) = norm( y - X(:,j,i) );
    end
    err_NN(i) = min( Perr_NN );
    Perr_NN = [];
end
[NN_m,NN_Ind] = min( err_NN );
if NN_Ind == sub
    NN = 1;
else
    NN = 0;
end