% Y: D x N matrix of N data points in D dimensional space
% y: D x 1 test data vector
% Tn: vector of n elements indicating the number of trainings for each of
% the n class
% d: dimension of face subspace (Typically 9)
% sub: index of the groundtruth subject for the test data y
%--------------------------------------------------------------------------
% Copyright @ Ehsan Elhamifar, 2012
%--------------------------------------------------------------------------


function [NS,err_NS] = NearestSubspace(Y,y,Tn,d,sub)

n = length(Tn);
ind = 0;
for i = 1:n
    X(:,:,i) = Y(:,ind+1:ind+Tn(i));
    ind = ind + Tn(i);
    [U,S,V] = svd( X(:,:,i) );
    err_NS(i) = norm( y - U(:,1:d) * U(:,1:d)' * y );
end
[NS_m,NS_Ind] = min( err_NS );
if NS_Ind == sub
    NS = 1;
else
    NS = 0;
end