function H = showAffinity(C, s)
% showAffinity plot a picture of affinity matrix

% C: N-by-N is the symmetric affinity matrix. s: N-by-1 is the label
% H is the handle.

% By Chong You, 2014

N = length(s);
% process the affinity
C = C - diag(diag(C));
Affinity_squareform = squareform(C);
C = ( C - min(Affinity_squareform) ) / ...
    (max(Affinity_squareform) - min(Affinity_squareform)); % normalize to [0, 1];
C = C - diag(diag(C));
% order groups
[s, order] = sort(s);
C = C(order, order);
% find boundaries
b = find(diff(s)) + 0.5;
%
H = figure; 
imagesc(C); hold on; colorbar;
for ii = 1:length(b)
    plot( b(ii) * ones(N, 1), 1:N, 'ok', 'markersize', 1);
    plot( 1:N, b(ii) * ones(N, 1), 'ok', 'markersize', 1);
end
