function imembed(H_f, H_a, X, I, S)
% IMEMBED embeds images in a plot.

% This function is used for visualizing lower dimensional embedding of 
% image data (e.g. face, digits).
% imembed(H, X, I, S) puts an image I(:, ii) by the side of a two 
% dimensional data point X(:, ii) in an existing plot. H_f specifies the 
% figure and H_a specifies the 
% axes. The size of the input images is specified by S (e.g. S = [192, 168])

% By Chong You, 2014

N = size(X, 2); % number of data points.

state = false(1, N); % state for whether image is shown for each point.
h = gobjects(1, N); % handles to the images for each point.

figure(H_f); hold all; set(H_f, 'color', 'white'); 
% figure_pos = get(H, 'Position');
% aspect_ratio = get(H_axes, 'plotboxaspectratio');
% position_a = get(H_a(1), 'position');

% x_range_zoom = get( H_a(2), 'xlim' );
% y_range_zoom = get( H_a(2), 'ylim');
% x_scale_zoom = diff(x_range_zoom);
% y_scale_zoom = diff(y_range_zoom);
% position_a_zoom = get(H_a(2), 'position');
% x_scale_zoom = x_scale_zoom * position_a(3) / position_a_zoom(3);
% y_scale_zoom = y_scale_zoom * position_a(4) / position_a_zoom(4);

fprintf('Instructions: \n')
fprintf('Left click on a data point to display an image to the up-right;\n')
fprintf('Left click again can remove it;\n')
fprintf('Right click at any place in the figure to get to the options.\n')
drawing_option = 1; % top-left
while(1)
    % get a point
    [x, y, button] = ginput(1); 
    if button ~= 1
        prompt = '0: finished. 1: draw at top-left. 2: draw at top-right. 3: draw at bottom left. 4: draw at bottom right.\n';
        while 1     
            userInput = input(prompt);
            if userInput == 0
                return;
            elseif ismember(userInput, 1:4)
                drawing_option = userInput;
                break;
            else
                fprintf('Input not valid\n')
            end
        end
    else
        idx = knnsearch(X', [x, y]);
        % add or delete an image
        if state(idx) == false % add an image
            im = imnormalize( reshape( I(:, idx), S ) );
            im = rot90(im,2);
            im = cat(3, im, im, im);
            pos = X(:, idx);
            % put image (im) at position (pos)
            RI = imref2d(S);
            x_range = get( H_a(1), 'xlim' );
            y_range = get( H_a(1), 'ylim');
            x_scale = diff(x_range);
            y_scale = diff(y_range);
            if gca == H_a(1)
                x_scale_tmp = x_scale;
                y_scale_tmp = y_scale;
            else
                x_scale_tmp = x_scale_zoom;
                y_scale_tmp = y_scale_zoom;               
            end
            if mod(drawing_option, 2) == 1 % left
                RI.XWorldLimits = [pos(1) - 5e-4* x_scale_tmp * S(2), pos(1)];
            else
                RI.XWorldLimits = [pos(1), pos(1) + 5e-4* x_scale_tmp * S(2)];
            end
            if drawing_option <= 2 % up
                RI.YWorldLimits = [pos(2), pos(2) + 5e-4* y_scale_tmp * S(1)];
            else
                RI.YWorldLimits = [pos(2) - 5e-4 * y_scale_tmp * S(1), pos(2)];
            end
            hold on
            h(idx) = imshow(im, RI);
            set(H_a(1), 'ydir', 'normal');
%             set(H_a(2), 'ydir', 'normal');
%             set(H_axes, 'xlim', x_range);
%             set(H_axes, 'ylim', y_range);
            set(H_a(1), 'dataaspectratio', get(H_a(1), 'plotboxaspectratio'));
%             set(H_a(2), 'dataaspectratio', get(H_a(2), 'plotboxaspectratio'));
%             set(H, 'Position', figure_pos);
%             set(H,'units','normalized','outerposition',[0 0 1 1])
            figure(H_f); hold on;
        else % delete an image
            delete( h(idx) );
        end
        state(idx) = ~state(idx);
    end
end