function [global_groups, global_obj] = ksubspaces(data, n, d, varargin)
% data: D by N data matrix. 
% n: number of subspaces
% d: dimension of subspaces

% Set default 
vararg = {'replicates', 5};
% Overwrite by input
vararg = vararginParser(vararg, varargin);
% Generate variables
for pair = reshape(vararg, 2, []) % pair is {propName;propValue}
   eval([pair{1} '= pair{2};']);
end

[D, N] = size(data);

global_obj = +inf;
global_groups = [];
for ireplicates = 1:replicates
    % initialization
    mu = cell(1, n);
    U = cell(1, n);
    
%         mu_r = cell(1, n);
%         U_r = cell(1, n);
    
    mu0 = mean(data, 2);
    data_0 = bsxfun(@minus, data, mu0);
    Sigma0 = data_0 * data_0' / N;
    [U0, ~] = eigs(Sigma0, d);
    for ii = 1:n
        mu{ii} = mu0 + 0.01 * randn(D, 1);
        basis = U0 + 0.01 * randn(D, d);
        [U{ii}, ~, ~] = svd(basis, 'econ');
        
%             mu_r{ii} = mu{ii};
%             U_r{ii} = U{ii};
            
%             mu{ii} = mu_r{ii};
%             U{ii} = U_r{ii};
    end
    % iterations
    iter = 0;
    groups_0 = zeros(1, N);
    while(1)
        % - segmentation
        % compute distance of each point to each subspace
        dist = zeros(n, N); 
        for ii = 1:n
            dist(ii, :) = sum( ((eye(D) - U{ii}*U{ii}') * bsxfun(@minus, data, mu{ii})) .^2, 1);
        end
        % compute weight
        W = zeros(n, N);
        [~, idx] = min(dist);
        W(sub2ind([n, N], idx, 1:N)) = 1;

        % - estimation
        for ii = 1:n
            if sum(W(ii, :)) == 0
                mu{ii} = mu0 + 0.01 * randn(D, 1);
                basis = U0 + 0.01 * randn(D, d);
                [U{ii}, ~, ~] = svd(basis, 'econ');
            else
                mu{ii} = data * W(ii, :)' / sum(W(ii, :));
                data_0 = bsxfun(@minus, data, mu{ii});
                [U{ii}, ~, ~] = eigs( bsxfun(@times, W(ii, :), data_0) * data_0', d );
            end
        end

        iter = iter + 1;
        [~, groups] = max(W, [], 1); % format output.
  
%         scatter(1:N, groups, 10, 'r'); axis([0 N 0.7 2.3]); hold on; box on; 
%         line([64.5, 64.5], [0.7, 2.3], 'LineStyle', ':');
%         set(gca,'ytick',[]); pbaspect([1, 0.3, 1])
%         saveas(gcf, fullfile('result', ['C6_face_ksubspace' num2str(iter)]), 'epsc');
%         close(gcf);
%         Misclassification(groups, s)
        if (isequal(groups, groups_0) && length(unique(groups)) == n) || (iter == 50)
            obj = sum(sum(W .* dist));
            break;
        else
            groups_0 = groups;
        end
    end
    fprintf('K-subspaces: %d in %d finished, objective: %f\n', ireplicates, replicates, obj);
    if obj < global_obj
        global_obj = obj;
        global_groups = groups;
    end
end
