function [b,group,membership,c,sigma_sq,indexeval,Dpn,Ln] = gpca_pda(x,n,delta,robust)
% [b,group] = gpca_pda_kneigh(x,n,K,delta)
%
% POLYNOMIAL DIFFERENTIATION ALGORITHM (PDA) WITH HEURISTIC DISTANCE
% Given a set of N data points x (K by N) lying on a collection of
% n hyperplanes, it determines the normal vectors b (K by N) to 
% each one of the hyperplanes and the segmentation of the data.
% The algorithm 
% 1) applies PCA to the data
% 2) fits a polynomial p to the data
% 3) evaluates a normal as the derivative of p at point mimimizing a distance
% 4) Given normal, recomputes the distance and goes to 3)
%
if nargin < 4
    robust = 0;
end

[K,N] = size(x);
Mn = nchoosek(n+K-1,n);

% Apply linear transformation to data for better numerical stability
%[Ux,Sx,Vx] = svd(x,0); % x is mapped to U'x
Ux=eye(K);
x = Ux'*x;
    
% Obtain coefficients of polynomial
[Ln,powers] = veronese(x,n);
Ln = conj(Ln');

if robust ==1 
    c = robustnull(Ln);
else
    [U,S,V] = svd(Ln,0);
    c = V(:,Mn);
end

% PICK A POINT IN ONE SUBSPACE AS THE POINT THAT HAS MINIMUM ERROR

[Dpn,normDpn] = cnormalize(derivative(c,powers,x));
distance = abs(Ln*c)'./normDpn;
[val,index] = min(distance);
% COMPUTE NORMAL TO FIRST SUBSPACE FROM THE JACOBIAN OF THE POLYNOMIAL
b(:,1) = cnormalize(derivative(c,powers,x(:,index)));
indexeval(1)=index;

% FOR THE REMAINING SUBSPACES
den = 1;
for i = 1:n-1
  % PICK A POINT IN ONE SUBSPACE
  den         = den.*sqrt(sum(conj(conj(b(:,i)')*x).*(conj(b(:,i))'*x),1)); 
  [val,index] = min((distance + delta)./(den + delta));
  b(:,i+1)    = cnormalize(derivative(c,powers,x(:,index)));
  indexeval(i+1)=index;
end

% Segment the points: assign z to b such that (z'b) is mimimum
distance = abs(conj(b)'*cnormalize(x));
[val,group] = min(distance,[],1); 
sigma_sq = 1e-5;
for i=1:n
    if ~isempty(find(group==i))
        sigma_sq = sigma_sq + var(distance(find(group==i)));
    end
end
sigma_sq = sigma_sq /n;

membership = exp(-distance.^2/sigma_sq);
membership = membership./(ones(n,1)*sum(membership,1));
% 
% affMat=zeros(size(Dpn,2));
% for(i=1:size(Dpn,2))
%     for(j=2:size(Dpn,2))
%         affMat(i,j)=Dpn(:,i)'*Dpn(:,j);
%     end
% end
%         
% %[diagMat,LMat,X,Y,group,errorsum]= spectralcluster(affMat,N,n);


% Undo the linear transformation
b = conj(Ux)*b;%(K:-1:1,:);
b = cnormalize(b);
