function [group,c,Dpn,Ln] = gpca_pda_spectralcluster(x,n,k,scalepow,robust)
% [group] = gpca_pda_spectralcluster(x,n,k,scalepow)
%
% POLYNOMIAL DIFFERENTIATION ALGORITHM (PDA) WITH HEURISTIC DISTANCE
% Given a set of N data points x (K by N) lying on a collection of
% n hyperplanes, it determines the normal vectors b (K by N) to 
% each one of the hyperplanes and the segmentation of the data.
% The algorithm 
% 1) applies PCA to the data
% 2) fits a polynomial p to the data
% 3) Segment the data using the normals of the polynomial on each point and
%    applying spectral clustering (using k eigenvectors, by default k=n).
%    The normals are not normalized and the similarity matrix is scaled
%    according to (abs(affMat)).^scalepow (by default, scalepow=1)

if nargin < 5
    robust = 0;
end

if (nargin<4)
    scalepow=1;
end

if (nargin<3)
    k=n;
end

[K,N] = size(x);
Mn = nchoosek(n+K-1,n);

% Apply linear transformation to data for better numerical stability
%[Ux,Sx,Vx] = svd(x,0); % x is mapped to U'x
Ux=eye(K);
x = Ux'*x;
    
% Obtain coefficients of polynomial
[Ln,powers] = veronese(x,n);
Ln = conj(Ln');

if robust ==1 
    c = robustnull(Ln);
else
    [U,S,V] = svd(Ln,0);
    c = V(:,Mn);
end

%compute all the normals
[Dpn,normDpn] = cnormalize(derivative(c,powers,x));

%compute the similarity matrix
affMat=(abs(Dpn'*Dpn).^scalepow);

%segment using spectral clustering
[diagMat,LMat,X,Y,group,errorsum]=spectralcluster(affMat,k,n);
