function [coeff] = gpca_rda(xx,c,n,K,delta,error,powers)
%GPCA Generalized Principle Component Analysis by Recursive Differentiation
%   COEFF = GPCA_RDA(T,n,K) factorizes the n-th order symmetric tensor
%   T in K variables into n 1st order tensors (vectors) in K
%   variables, using the recursive division algorithm. 
%   x is a KxN containing data points on the subspaces
%   coeff is a n by K matrix with those vectors as rows.
%   Equivalently, T can be seen as the coeffficients of a
%   homogeneous polynomial of order n in K variables. GPCA gives
%   the coefficients of the factorization of T into n linear
%   functionals in K variables.
%   T is a vector of dimension nchoose(n+K-1,n) times 1
%
%   See also GPCA, SYMKRON

%   Copyright 2003 Rene Vidal
%   $Revision: 1.1 $  $Date: 2004/05/26 19:34:40 $

% PICK A POINT IN ONE SUBSPACE AS THE POINT THAT HAS MINIMUM ERROR
num = abs(error); %sqrt(sum((c'*lift(xx,n)).^2,1)); 
[val,ind(1)] = min(num);
y = xx(:,ind(1));
npoints=2;

% COMPUTE NORMAL TO FIRST SUBSPACE FROM THE JACOBIAN OF THE POLYNOMIAL
bb(:,1) = cnormalize(derivative(c,powers,y));

% FOR THE REMAINING SUBSPACES
den = 1;

for i = 1:n-1
  % PICK A POINT IN ONE SUBSPACE
  den = den.*sqrt(sum((bb(:,i)'*xx).^2,1)); 
  [val,ind(i+1)] = min((num + delta)./(den + delta));
  y = [y xx(:,ind(i+1))];
  bb(:,i+1) = cnormalize(derivative(c,powers,y(:,i+1)));
end

coeff = (bb)';
%ind
