% LINE_COEFF(c,v,x0,n,powers)
% Computes the coefficients of a univariate polynomial q_n(t) of degree
% n from the coefficients c of a homogeneous polynomial p_n(x) such that
% q_n(t) = p_n(t v + x0). Powers is the matrix of exponents of p_n.

function [coeff,allcoeff]= line_coeff(c,v,x0,n,powers)

% The univariate polynomial we are looking for is a linear combination of
% univariate polynomials coming from monomials of the form 
% q_{n1...nK} (t) = x1^n1 ... xK^nK = (t*v1 + x01)^n1 ... (t*vK+ x0K)^nK
% Therefore, the roots of q_{n1...nK} (t) are - x0j/vj repeated nj times.
% Therefore, we can compute the coefficients of q_{n1...nK} (t) 
% by taking the vector -x0./v (ratio), repeating each one of its entries 
% according to the vector of powers (rootvect) and then use MATLAB poly
% function to get the coefficients of q_{n1...nK} (t) up to a scale factor.
% The scale factor is v1^n1 .... vK^nK which can be computed.
% Then the polynomial is scaled by the corresponding entry of c and summed

K = size(v,1);

ratio = -x0./v;
coeff = zeros(1,n+1);
for i=1:size(c,1)
  rootvect = [];
  %repeating each entry of ratio according to the vector of powers 
  for j=1:K
    rootvect = [rootvect; ratio(j)*ones(powers(i,j),1)];
  end
  % building the polynomial
  allcoeff(i,:) = prod(v.^(powers(i,:)'))*poly(rootvect);
  coeff = coeff + c(i)* allcoeff(i,:);
end
