function [b, group] = ASC_LineIntersection(X,n,restarts)

[K,N] = size(X);
Mn = nchoosek(n+K-1,n);

% Obtain coefficients of polynomial
[Ln,powers] = veronese(X,n);
Ln = conj(Ln');
[U,S,V] = svd(Ln,0);
c = V(:,Mn); 

err = 1e6;

if nargin < 6
  restarts = 1; % numer of random lines to be chosen
end

for lines=1:restarts
  % Intersect polynomial c with a random line
  v  = cnormalize(randn(K,1));
  x0 = cnormalize(randn(K,1));

  % Find univariate polynomial corresponding to the line
  line_c = line_coeff(c,v,x0,n,powers);
  % Use the roots to compute intersecting points
  points = [v x0]*[roots(line_c) ones(n,1)]';

  % Evaluate the derivative at each point to get normal vectors
  for i=1:n
    b(:,i) = cnormalize(derivative(c,powers,points(:,i)));
  end
  
  % Choosing the best line: the one with minimum reconstruction error

  newerr=sqrt(mean(min(abs(b'*X).^2,[],1)));
  if (newerr < err)
    coeff = b;
    err = newerr;
  end

end

coeff = coeff';


% Segment the points: assign z to b such that abs(z'b) is mimimum

distance = abs(conj(b)'*cnormalize(X));

[val,group] = min(distance,[],1); 

sigma_sq = 1e-5;

for i=1:n

    sigma_sq = sigma_sq + var(distance(find(group==i)));

end

sigma_sq = sigma_sq /n;



membership = exp(-distance.^2/sigma_sq);

membership = membership./(ones(n,1)*sum(membership,1));





